﻿using System;
using PostitCore;
using PostitCommon;
using System.Collections.Generic;
using Newtonsoft.Json;
using System.Net.Http;

namespace DeXGets
{
    public class ContactContactBasics : BaseClass
    {
        public class ContactBasics_Response
        {
            public Guid ExternalID;
            public string Surname;
            public string Forename;
            public string Salutation;
            public BaseLookups Title;
            public BaseLookups Gender;
        }
        /// <summary>
        /// Returns the set of contact contact basics
        /// </summary>
        /// <param name="token"></param>
        /// <param name="key"></param>
        /// <param name="httpClient"></param>
        /// <returns></returns>
        public Dictionary<Guid, ContactBasics_Response> GetValues(string token, string key, HttpClient httpClient)
        {
            Dictionary<Guid, ContactBasics_Response> values = new Dictionary<Guid, ContactBasics_Response>();
            string URL_ContactDetails = SetURL("Learner", "ContactBasics");
            string resp = DoCall(URL_ContactDetails, token, httpClient, key);
            ODataResponse<ContactBasics_Response> contacts = null;
            try
            {
                contacts = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<ContactBasics_Response>>(resp);
                foreach (ContactBasics_Response s in contacts.Value)
                {
                    values.Add(s.ExternalID, s);
                }
                // Very likely > 1000
                while (!string.IsNullOrEmpty(contacts.NextLink))
                {
                    resp = DoCall(GetNextLink(contacts.NextLink), token, httpClient, key);
                    contacts = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<ContactBasics_Response>>(resp);
                    foreach (ContactBasics_Response s in contacts.Value)
                    {
                        values.Add(s.ExternalID, s);
                    }
                }
            }
            catch
            {
                ErrorMessage = "Error: " + resp;
            }
            return values;
        }
    }
}
